/* 
 * io.c
 * 
 * Copyright (C) 2002, AVM GmbH. All rights reserved.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301  USA
 * 
 * Contact:
 *   AVM GmbH, Alt-Moabit 95, 10559 Berlin, Germany, email: info@avm.de
 */

#include <asm/io.h>

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
unsigned char InpByte (unsigned port) {

	return inb (port);
} /* InpByte */

void OutpByte (unsigned port, unsigned char data) { 

	outb (data, port); 
} /* OutpByte */

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
unsigned long InpDWord (unsigned port) { 

	return inl (port); 
} /* InpDWord */

void OutpDWord (unsigned port, unsigned long data) { 

	outl (data, port); 
} /* OutpDWord */

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
void InpByteBlock (unsigned port, unsigned char * buffer, unsigned length) {

	insb (port, buffer, length);
} /* InpByteBlock */

void OutpByteBlock (unsigned port, unsigned char * buffer, unsigned length) {

	outsb (port, buffer, length);
} /* OutpByteBlock */

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
void InpDWordBlock (unsigned port, unsigned char * buffer, unsigned length) {

	insl (port, buffer, (length + 3) / 4);
} /* InpDWordBlock */

void OutpDWordBlock (unsigned port, unsigned char * buffer, unsigned length) {

	outsl (port, buffer, (length + 3) / 4);
} /* OutpDWordBlock */

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/

