/* 
 * queue.h
 * 
 * Copyright (C) 2002, AVM GmbH. All rights reserved.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301  USA
 * 
 * Contact:
 *   AVM GmbH, Alt-Moabit 95, 10559 Berlin, Germany, email: info@avm.de
 */

#ifndef __have_queue_h__
#define __have_queue_h__

#include <linux/skbuff.h>
#include "tools.h"
#include "lock.h"

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
typedef long long		tag_t;
typedef __u32			NCCI_t;

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
typedef struct __qitem {

	tag_t			key;
	struct sk_buff *	msg;
	struct __qitem *	succ;
	struct __qitem *	pred;
} qitem_t;

typedef struct __queue {

	qitem_t *		put;
	qitem_t *		get;
	qitem_t *		noconf;
	lock_t			lock;
} queue_t;

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
extern void queue_init (queue_t **);
extern void queue_exit (queue_t **);

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
extern int queue_put (queue_t *, struct sk_buff *);
extern struct sk_buff * queue_get (queue_t *);

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
extern int queue_is_empty (queue_t *);

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
extern void queue_park (queue_t *, struct sk_buff *, unsigned, NCCI_t, unsigned);
extern void queue_conf (queue_t *, unsigned, NCCI_t, unsigned);

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
#endif


