/* 
 * lib.h
 * 
 * Copyright (C) 2002, AVM GmbH. All rights reserved.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301  USA
 * 
 * Contact:
 *   AVM GmbH, Alt-Moabit 95, 10559 Berlin, Germany, email: info@avm.de
 */

#ifndef __have_lib_h__
#define __have_lib_h__

#include "defs.h"
#include "libdefs.h"

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
extern lib_callback_t * get_library (void);
extern lib_callback_t * link_library (void *);
extern void free_library (void);

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
#if defined (DRIVER_TYPE_INTERN)
extern __attr void printl (char *, ...);
#endif

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
extern __attr void os_timer_poll (void);

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
extern __attr2 void * lib_memcpy (void *, const void *, size_t);
extern __attr2 void * lib_memset (void *, int, size_t);
extern __attr2 int lib_memcmp (const void *, const void *, size_t);
extern __attr2 void * lib_memmove (void *, const void *, size_t);

extern __attr2 char * lib_strcpy (char *, const char *);
extern __attr2 char * lib_strncpy (char *, const char *, unsigned);
extern __attr2 char * lib_strcat (char *, const char *);
extern __attr2 int lib_strcmp (const char *, const char *);
extern __attr2 int lib_strncmp (const char *, const char *, unsigned);

extern __attr2 size_t lib_strlen (const char * s);

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
#endif
