/* 
 * defs.h
 * 
 * Copyright (C) 2002, AVM GmbH. All rights reserved.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301  USA
 * 
 * Contact:
 *   AVM GmbH, Alt-Moabit 95, 10559 Berlin, Germany, email: info@avm.de
 */

#ifndef __have_defs_h__
#define __have_defs_h__

#ifndef LINUX_VERSION_CODE
# include <linux/version.h>
#endif

#ifndef TRUE
# define TRUE	(1==1)
# define FALSE	(1==0)
#endif

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
#if defined (__fcusb__)
# define PRODUCT_LOGO		"AVM FRITZ!Card USB"
# define PRODUCT_TYPE		1
#elif defined (__fcusb2__)
# define PRODUCT_LOGO		"AVM FRITZ!Card USB v2"
# define PRODUCT_TYPE		1
#elif defined (__fxusb__)
# define PRODUCT_LOGO		"AVM FRITZ!X USB/FRITZ!X ISDN"
# define PRODUCT_TYPE		1
#elif defined (__teumex2k__)
# define PRODUCT_LOGO		"T-Eumex 2000PC SE"
# define PRODUCT_TYPE		2
#elif defined (__teumex4k__)
# define PRODUCT_LOGO		"T-Eumex 4000PC"
# define PRODUCT_TYPE		2
#elif defined (__e2220pc__)
# define PRODUCT_LOGO		"Eumex 2220PC"
# define PRODUCT_TYPE		2
#elif defined (__e5520pc__)
# define PRODUCT_LOGO		"Eumex 5520PC"
# define PRODUCT_TYPE		2
#else
# error You have to define a card identifier...
#endif
#define	INTERFACE		"usb"

#if PRODUCT_TYPE == 2
# define PRODUCT_NAME		"eumex"
#else
# define PRODUCT_NAME		"fritz"
#endif

#define	SHORT_LOGO		PRODUCT_NAME INTERFACE
#define	DRIVER_LOGO		PRODUCT_LOGO " driver"
#define	DRIVER_TYPE_USB
#define	DRIVER_TYPE_ISDN
#define	DRIVER_REV		"0.9.1"

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
#if defined (OSDEBUG) && defined (NDEBUG)
# undef NDEBUG
#endif

#define	UNUSED_ARG(x)	(x)=(x)

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
#endif

