/* 
 * libstub.h
 * 
 * Copyright (C) 2002, AVM GmbH. All rights reserved.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301  USA
 * 
 * Contact:
 *   AVM GmbH, Alt-Moabit 95, 10559 Berlin, Germany, email: info@avm.de
 */

#ifndef __have_libstub_h__
#define __have_libstub_h__

#include "libdefs.h"

#if defined (OSDEBUG) && defined (NDEBUG)
# undef NDEBUG
#endif

#if defined (DRIVER_TYPE_DSL)
extern __attr2 lib_callback_t * avm_lib_attach (lib_interface_t *, void *);
#else
extern __attr2 lib_callback_t * avm_lib_attach (lib_interface_t *);
#endif

extern __attr2 void avm_lib_detach (lib_interface_t *);

#if defined (DRIVER_TYPE_DSL_RAP) || defined (DRIVER_TYPE_DSL_TM)
extern __attr2 lib_interface_t * avm_get_interface (void);
#endif

#if defined (DRIVER_TYPE_INTERN)
extern volatile unsigned long avm_time_base;
#endif

#endif

